﻿using UnityEngine;
using System.Collections;

[System.Serializable]
public class Boundary {
    public float yMin, yMax, zMin, zMax;
}

public class MoveSubmarine : MonoBehaviour {


    
    public GameObject helice;
    public GameObject presenceLight;
    public GameObject phareLight;
    public GameObject phareLight2;
    
    public GameObject torpedoPrefab;
    public ParticleSystem traineePrincipale;
    public ParticleSystem traineeHelice;


    public AudioClip moteurON;
    public AudioClip torpedoFireSFX;

    public float speed = 10.0f;
    public float tilt;
    public float rotateSpeedHelice;
    public Boundary boundary;

    public AudioSource source1;
    public AudioSource source2;
    public float cadence;
    public float ancientir;

    public GameObject lvl1;
    public GameObject lvl2;

    // Use this for initialization------------------------------------------------------------------------------------------------------
    void Start ()
    {
        StartCoroutine("lightBlink");

        FollowSubMArine followSubMArine = Camera.main.GetComponent<FollowSubMArine>();

        followSubMArine.submarine = this.transform;
        ancientir = 0;

       GameObject lvl1 = GameObject.Find("LVL1(Clone)");
        GameObject lvl2 = GameObject.Find("LVL2(Clone)");
        GameObject lvl3 = GameObject.Find("LVL3(Clone)");

        if (lvl1!=null)
         {
            boundary.yMin = -215;
            boundary.yMax = 275;
            boundary.zMin = -Screen.width / 2;
            boundary.zMax = 6100;

        }

        if (lvl2 != null)
        {
            boundary.yMin = -200;
            boundary.yMax = 210;
            boundary.zMin = 8000-Screen.width / 2;
            boundary.zMax = 16000;

        }

        if(lvl3!= null)
        {
            boundary.yMin = -445;
            boundary.yMax = 200;
            boundary.zMin = 16000 - Screen.width / 2;
            boundary.zMax = 24000;
        }


        







    }


    // Update is called once per frame-------------------------------------------------------------------------------------------------
    void Update()
    {
        GameObject lvl1 = GameObject.Find("LVL1(Clone)");
        GameObject lvl2 = GameObject.Find("LVL2(Clone)");
        GameObject lvl3 = GameObject.Find("LVL3(Clone)");

        //CONTROL PLAYER***********************************************
        float moveHorizontal = Input.GetAxis("Horizontal");
        float moveVertical = Input.GetAxis("Vertical");


        Vector3 movement = new Vector3(0.0f, moveVertical, moveHorizontal);
        GetComponent<Rigidbody>().velocity = movement * speed;

        GetComponent<Rigidbody>().position = new Vector3(
           transform.position.x,
           Mathf.Clamp(GetComponent<Rigidbody>().position.y, boundary.yMin, boundary.yMax),
           Mathf.Clamp(GetComponent<Rigidbody>().position.z, boundary.zMin, boundary.zMax)
       );
        GetComponent<Rigidbody>().rotation = Quaternion.Euler(GetComponent<Rigidbody>().velocity.y * -tilt, 0.0f, 0.0f);

        if (Input.GetKeyDown(KeyCode.L)){
            if (phareLight.activeSelf == true)
            {
                phareLight.SetActive(false);
                phareLight2.SetActive(false);
            }
            else
            {
                phareLight.SetActive(true);
                phareLight2.SetActive(true);
            }
        }
        if (Input.GetKeyDown(KeyCode.Space) && ancientir<Time.time-cadence)
        {
            // on lance la torpille
            GameObject torpedo = Instantiate(torpedoPrefab, (transform.position + new Vector3 (7.0f, -13.0f,30.0f)), transform.rotation) as GameObject;
            ancientir = Time.time;
            source2.clip = torpedoFireSFX;
            source2.Play();
            
        }
    
        
    }
    // LUMIERE ROUGE clignotante-----------------------------------------------------------------------------------------------------
    public IEnumerator lightBlink()
    {
        float timer = 1.0f;
        while (true)
        {
            presenceLight.SetActive(false);
            yield return new WaitForSeconds(timer);
            presenceLight.SetActive(true);
            yield return new WaitForSeconds(timer);
        }
    }


    // Update is called once per frame--------------------------------------------------------------------------------------------------
    void FixedUpdate()
    {
        GameObject lvl1 = GameObject.Find("LVL1(Clone)");
        GameObject lvl2 = GameObject.Find("LVL2(Clone)");
        GameObject lvl3 = GameObject.Find("LVL3(Clone)");


        // Conditions de fin lvl-------------------------------------------------------------------------------------------------

        if (lvl1!=null && GetComponent<Rigidbody>().position.z> 5990)
        {

            Score.tpsLvl1 = Mathf.Round(Score.tpsecoulé);
            Score.scoreLvl1 = Score.score+10*Score.tpsRestant;

            if(Score.scoreLvl1>Score.meilleurScoreLvl1)
            {
                Score.meilleurScoreLvl1 = Score.scoreLvl1;
                Score.meilleurTpsLvl1 = Score.tpsLvl1;

                PlayerPrefs.SetFloat("meilleur_score1", Score.meilleurScoreLvl1);
                PlayerPrefs.SetFloat("meilleur_tps1", Score.meilleurTpsLvl1);
            }

            StateMachine.instance.SetState(STATE.SCORE);
            
        }

        if (lvl2 != null && GetComponent<Rigidbody>().position.z > 15790)
        {
            Score.tpsLvl2 = Mathf.Round(Score.tpsecoulé);
            Score.scoreLvl2 = Score.score + 10 * Score.tpsRestant;

            if (Score.scoreLvl2 > Score.meilleurScoreLvl2)
            {
                Score.meilleurScoreLvl2 = Score.scoreLvl2;
                Score.meilleurTpsLvl2 = Score.tpsLvl2;

                PlayerPrefs.SetFloat("meilleur_score2", Score.meilleurScoreLvl2);
                PlayerPrefs.SetFloat("meilleur_tps2", Score.meilleurTpsLvl2);
            }

            StateMachine.instance.SetState(STATE.SCORE);
        }


        //HELICE*********************************************************************

        if (GetComponent<Rigidbody>().velocity.z != 0)
        {

            helice.transform.Rotate(Vector3.back, GetComponent<Rigidbody>().velocity.z * rotateSpeedHelice);
            if (source1 != null)
            {
                if (!source1.isPlaying)
                {
                    source1.clip = moteurON;
                    source1.Play();
                    traineeHelice.Play();
                    traineePrincipale.Play();
                }
            
            }
        }

        else
        {
            source1.Stop();
            traineeHelice.Stop();
            traineePrincipale.Stop();

        }
        


        
    }

    
    }
